LIBRARY ieee;
   use ieee.std_logic_1164.all;

package PCpuRegisters is

   -- Cpu control registers (values are changed by uC, can be read by uC and VHDL)
   type TCpuCtrlRegEnum is
   (
      -- 0 CPU

      REG_CTRL_FIRMWARE_VERSION_PROD,
      REG_CTRL_FIRMWARE_VERSION_MAJ,
      REG_CTRL_FIRMWARE_VERSION_MIN,

      REG_CTRL_MASK_LEVEL_INT,
      REG_CTRL_MASK_EDGE_INT,

      REG_CTRL_DEBUG,

      REG_CTRL_USB,
      REG_CTRL_USB_PROD_ID,
      REG_CTRL_USB_STR_IDX,
      REG_CTRL_USB_SERIAL_7,
      REG_CTRL_USB_SERIAL_6,
      REG_CTRL_USB_SERIAL_5,
      REG_CTRL_USB_SERIAL_4,
      REG_CTRL_USB_SERIAL_3,
      REG_CTRL_USB_SERIAL_2,
      REG_CTRL_USB_SERIAL_1,
      REG_CTRL_USB_SERIAL_0,
      REG_CTRL_USB_BUF_ADD,
      REG_CTRL_USB_BUF_DATA,
      REG_CTRL_USB_BUF_WE,

      -- icap control register
      REG_CTRL_ICAP_SEND,
      REG_CTRL_ICAP_OPCODE_LSB,
      REG_CTRL_ICAP_OPCODE_MSB,
      REG_CTRL_ICAP_USERDATA_LSB,
      REG_CTRL_ICAP_USERDATA_MSB,
      REG_CTRL_ICAP_FALLBACK,

      REG_CTRL_DATAFRAME_0_TXCTRL,
      REG_CTRL_DATAFRAME_0_TYPE,
      REG_CTRL_DATAFRAME_0_OFFSET_LSB,
      REG_CTRL_DATAFRAME_0_OFFSET_MSB,
      REG_CTRL_DATAFRAME_0_LENGTH_LSB,
      REG_CTRL_DATAFRAME_0_LENGTH_MSB,

      REG_CTRL_DATAFRAME_1_TXCTRL,
      REG_CTRL_DATAFRAME_1_TYPE,
      REG_CTRL_DATAFRAME_1_OFFSET_LSB,
      REG_CTRL_DATAFRAME_1_OFFSET_MSB,
      REG_CTRL_DATAFRAME_1_LENGTH_LSB,
      REG_CTRL_DATAFRAME_1_LENGTH_MSB,

      REG_CTRL_DATAFRAME_2_TXCTRL,
      REG_CTRL_DATAFRAME_2_TYPE,
      REG_CTRL_DATAFRAME_2_OFFSET_LSB,
      REG_CTRL_DATAFRAME_2_OFFSET_MSB,
      REG_CTRL_DATAFRAME_2_LENGTH_LSB,
      REG_CTRL_DATAFRAME_2_LENGTH_MSB,

      REG_CTRL_DATAFRAME_3_TXCTRL,
      REG_CTRL_DATAFRAME_3_TYPE,
      REG_CTRL_DATAFRAME_3_OFFSET_LSB,
      REG_CTRL_DATAFRAME_3_OFFSET_MSB,
      REG_CTRL_DATAFRAME_3_LENGTH_LSB,
      REG_CTRL_DATAFRAME_3_LENGTH_MSB,

      REG_CTRL_MASK_EDGE_FRAME0,
      REG_CTRL_MASK_EDGE_FRAME1,

      REG_CTRL_SERIAL_0,
      REG_CTRL_SERIAL_1,
      REG_CTRL_SERIAL_2,

      REG_CTRL_SEED_EN,

      REG_CTRL_FIRMWARE_VERSION_BUILD_LSB,
      REG_CTRL_FIRMWARE_VERSION_BUILD_MSB,
      
      -- 1 Communication with on board chips (SPI, I2C)

      REG_CTRL_SPI,
      REG_CTRL_SPI_REQUEST,
      REG_CTRL_SPI_CMD,
      REG_CTRL_SPI_SRC_START_ADD_HL,
      REG_CTRL_SPI_SRC_START_ADD_LH,
      REG_CTRL_SPI_SRC_START_ADD_LL,
      REG_CTRL_SPI_SRC_END_ADD_HL,
      REG_CTRL_SPI_SRC_END_ADD_LH,
      REG_CTRL_SPI_SRC_END_ADD_LL,
      REG_CTRL_SPI_DEST_START_ADD_HL,
      REG_CTRL_SPI_DEST_START_ADD_LH,
      REG_CTRL_SPI_DEST_START_ADD_LL,
      REG_CTRL_SPI_LENGTH,
      REG_CTRL_SPI_FIFO,

      REG_CTRL_I2C_CFG1,
      REG_CTRL_I2C_PLL,
      REG_CTRL_I2C_SCALER,

      REG_CTRL_I2C_DEV_CFG1,
      REG_CTRL_I2C_DEV_PLL,
      REG_CTRL_I2C_DEV_SCALER,

      REG_CTRL_I2C_REG_CFG1,
      REG_CTRL_I2C_REG_PLL,
      REG_CTRL_I2C_REG_SCALER,

      REG_CTRL_I2C_LENGTH_CFG1,
      REG_CTRL_I2C_LENGTH_PLL,
      REG_CTRL_I2C_LENGTH_SCALER,

      REG_CTRL_I2C_FIFO_CFG1,
      REG_CTRL_I2C_FIFO_PLL,
      REG_CTRL_I2C_FIFO_SCALER,

      -- 2 Misc

      REG_CTRL_RST,

      REG_CTRL_EDID_ADD,
      REG_CTRL_EDID_DATA,
      REG_CTRL_EDID_MISC,

      REG_CTRL_GEN1,
      REG_CTRL_BUTTONS,

      REG_CTRL_VIDEO_JTAG,

      -- 3 Video

      REG_CTRL_H_TOTAL_H,
      REG_CTRL_H_TOTAL_L,
      REG_CTRL_H_ACTIVE_H,
      REG_CTRL_H_ACTIVE_L,
      REG_CTRL_H_BP_H,
      REG_CTRL_H_BP_L,
      REG_CTRL_H_SYNC_WIDTH_H,
      REG_CTRL_H_SYNC_WIDTH_L,
      REG_CTRL_V_TOTAL_H,
      REG_CTRL_V_TOTAL_L,
      REG_CTRL_V_ACTIVE_H,
      REG_CTRL_V_ACTIVE_L,
      REG_CTRL_V_BP,
      REG_CTRL_V_SYNC_WIDTH,
      REG_CTRL_H_FREQ_H,
      REG_CTRL_H_FREQ_L,
      REG_CTRL_V_FREQ_H,
      REG_CTRL_V_FREQ_L,
      REG_CTRL_P_FREQ_H,
      REG_CTRL_P_FREQ_L,
      REG_CTRL_VIDEO_MISC,
      REG_CTRL_VIDEO_MODE,

      REG_CTRL_CRC,

      REG_CTRL_VIDEO_SINK_1,
      REG_CTRL_VIDEO_SINK_2,
      REG_CTRL_VIDEO_SINK_3,
      REG_CTRL_VIDEO_SINK_4,
      REG_CTRL_VIDEO_SINK_5,
      REG_CTRL_VIDEO_SINK_6,

      -- 4 HDCP

      REG_CTRL_HDCP_CPBL,

      REG_CTRL_HDCP_BCAPS_PORT1,

      REG_CTRL_KSV_RAM_ADD,
      REG_CTRL_KSV_RAM_MISC,
      REG_CTRL_KSV_RAM_DATA,

      REG_CTRL_NEW_BKSV,

      REG_CTRL_HDCP_IN_ENABLED,
      
      REG_CTRL_KSV_RAM_POINTER_LOCAL,

      -- 5 Communication with Packet Router

      REG_CTRL_TX_PACKET_7,
      REG_CTRL_TX_PACKET_6,
      REG_CTRL_TX_PACKET_5,
      REG_CTRL_TX_PACKET_4,
      REG_CTRL_TX_PACKET_3,
      REG_CTRL_TX_PACKET_2,
      REG_CTRL_TX_PACKET_1,
      REG_CTRL_TX_PACKET_0,
      REG_CTRL_TX_PACKET_ADD_CAT,
      REG_CTRL_TX_PACKET_GEN,

      REG_CTRL_RX_PACKET_GEN_GTP0,
      REG_CTRL_RX_PACKET_GEN_GTP1,
      REG_CTRL_RX_PACKET_GEN_GTP2,
      REG_CTRL_RX_PACKET_GEN_GTP3,
--      REG_CTRL_RX_PACKET_CTRL_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_CTRL_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_CTRL_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_CTRL_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_DATA1_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_DATA1_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_DATA1_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_DATA1_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_DATA2_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_DATA2_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_DATA2_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_DATA2_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_DATA3_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_DATA3_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_DATA3_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_DATA3_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_DATA4_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_DATA4_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_DATA4_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_DATA4_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_DATA5_TMP1_GTP0,
--      REG_CTRL_RX_PACKET_DATA5_TMP1_GTP1,
--      REG_CTRL_RX_PACKET_DATA5_TMP1_GTP2,
--      REG_CTRL_RX_PACKET_DATA5_TMP1_GTP3,
--      REG_CTRL_RX_PACKET_CTRL_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_CTRL_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_CTRL_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_CTRL_TMP2_GTP3,
--      REG_CTRL_RX_PACKET_DATA1_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_DATA1_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_DATA1_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_DATA1_TMP2_GTP3,
--      REG_CTRL_RX_PACKET_DATA2_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_DATA2_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_DATA2_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_DATA2_TMP2_GTP3,
--      REG_CTRL_RX_PACKET_DATA3_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_DATA3_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_DATA3_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_DATA3_TMP2_GTP3,
--      REG_CTRL_RX_PACKET_DATA4_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_DATA4_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_DATA4_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_DATA4_TMP2_GTP3,
--      REG_CTRL_RX_PACKET_DATA5_TMP2_GTP0,
--      REG_CTRL_RX_PACKET_DATA5_TMP2_GTP1,
--      REG_CTRL_RX_PACKET_DATA5_TMP2_GTP2,
--      REG_CTRL_RX_PACKET_DATA5_TMP2_GTP3,

      -- 6 Packet Router

      REG_CTRL_ROUTER_TESTER_A_TX_1,
      REG_CTRL_ROUTER_TESTER_A_TX_2,
      REG_CTRL_ROUTER_TESTER_A_TX_3,
      REG_CTRL_ROUTER_TESTER_A_TX_4_LL,
      REG_CTRL_ROUTER_TESTER_A_TX_4_LH,
      REG_CTRL_ROUTER_TESTER_A_TX_4_HL,
      REG_CTRL_ROUTER_TESTER_A_TX_4_HH,
      REG_CTRL_ROUTER_TESTER_A_RX_1,

--      REG_CTRL_ROUTER_TESTER_B_TX_1,
--      REG_CTRL_ROUTER_TESTER_B_TX_2,
--      REG_CTRL_ROUTER_TESTER_B_TX_3,
--      REG_CTRL_ROUTER_TESTER_B_TX_4_LL,
--      REG_CTRL_ROUTER_TESTER_B_TX_4_LH,
--      REG_CTRL_ROUTER_TESTER_B_TX_4_HL,
--      REG_CTRL_ROUTER_TESTER_B_TX_4_HH,
--      REG_CTRL_ROUTER_TESTER_B_RX_1,

      REG_CTRL_ROUTER_BRIDGE_0_GENERAL_1,
      REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_LL,
      REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_LH,
      REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_HL,
      REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_HH,

      REG_CTRL_ROUTER_BRIDGE_1_GENERAL_1,
      REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_LL,
      REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_LH,
      REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_HL,
      REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_HH,

      REG_CTRL_ROUTER_BRIDGE_2_GENERAL_1,
      REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_LL,
      REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_LH,
      REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_HL,
      REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_HH,

      REG_CTRL_ROUTER_BRIDGE_3_GENERAL_1,
      REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_LL,
      REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_LH,
      REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_HL,
      REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_HH,

      REG_CTRL_ROUTER_SFP_TX_STATUS_LED_0,
      REG_CTRL_ROUTER_SFP_TX_STATUS_LED_1,
      REG_CTRL_ROUTER_SFP_TX_STATUS_LED_2,
      REG_CTRL_ROUTER_SFP_TX_STATUS_LED_3,

      REG_CTRL_ROUTER_SFP_RX_STATUS_LED_0,
      REG_CTRL_ROUTER_SFP_RX_STATUS_LED_1,
      REG_CTRL_ROUTER_SFP_RX_STATUS_LED_2,
      REG_CTRL_ROUTER_SFP_RX_STATUS_LED_3,

      -- 7 Audio

      REG_CTRL_AUDIO_TONE_MODE,
      REG_CTRL_AUDIO_AUX_DAC_DATA,
      REG_CTRL_AUDIO_AUX_DAC_ADDR,
      REG_CTRL_AUDIO_AUX_DAC_WE,
      REG_CTRL_AUDIO_AUX_CH_SEL,
      REG_CTRL_AUDIO_HDMI_CH_SEL0,
      REG_CTRL_AUDIO_HDMI_CH_SEL1,
      REG_CTRL_AUDIO_HDMI_CH_SEL2,
      REG_CTRL_AUDIO_HDMI_CH_SEL3,
      REG_CTRL_AUDIO_INSEL_MODE,
      REG_CTRL_AUDIO_EDID_SPEAKER_TO_IF_LUT,
      REG_CTRL_AUDIO_DM_PROC_RAM_ADDR,
      REG_CTRL_AUDIO_DM_PROC_RAM_DATA,
      REG_CTRL_AUDIO_DM_PROC_RAM_WE,
      REG_CTRL_AUDIO_SAMPLING_FREQ,

      REG_CTRL_SWITCH_MODE,

      REG_CTRL_CPU_SWITCH_PORT_MODE,
      REG_CTRL_CPU_SWITCH_PRIORITY_PORT0,
      REG_CTRL_CPU_SWITCH_PRIORITY_PORT1,
      REG_CTRL_CPU_SWITCH_PRIORITY_PORT2,
      REG_CTRL_CPU_SWITCH_PRIORITY_PORT3,

      REG_CTRL_VIDEO_SWITCH_PORT_MODE,
      REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT0,
      REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT1,
      REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT2,
      REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT3,

      REG_CTRL_AUDIO_SWITCH_PORT_MODE,
      REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT0,
      REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT1,
      REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT2,
      REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT3,

      REG_CTRL_RTESTER_SWITCH_PORT_MODE,
      REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT0,
      REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT1,
      REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT2,
      REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT3,

      REG_CTRL_SAI_SWITCH_PORT_MODE,
      REG_CTRL_SAI_SWITCH_PRIORITY_PORT0,
      REG_CTRL_SAI_SWITCH_PRIORITY_PORT1,
      REG_CTRL_SAI_SWITCH_PRIORITY_PORT2,
      REG_CTRL_SAI_SWITCH_PRIORITY_PORT3,

      REG_CTRL_SPI_ADR_MSB,
      REG_CTRL_SPI_ADR_LSB,
      REG_CTRL_SPI_DATA_MSB,
      REG_CTRL_SPI_DATA_LSB,
      REG_CTRL_SPI_SEND

   );

   -- Cpu status registers (values are changed by VHDL, can be read by uC and VHDL)
   type TCpuStatRegEnum is
   (
      -- 0 CPU

      REG_STAT_LEVEL_INT_CPU,

      REG_STAT_USB,
      REG_STAT_USB_BUF_DATA,

      REG_STAT_ICAP_BUSY,
      REG_STAT_ICAP_USERDATA_LSB,
      REG_STAT_ICAP_USERDATA_MSB,

      REG_STAT_DATAFRAME_0_TXCTRL,
      REG_STAT_DATAFRAME_1_TXCTRL,
      REG_STAT_DATAFRAME_2_TXCTRL,
      REG_STAT_DATAFRAME_3_TXCTRL,

      REG_STAT_DATAFRAME0_TYPE0,
      REG_STAT_DATAFRAME0_OFFSET0_LSB,
      REG_STAT_DATAFRAME0_OFFSET0_MSB,
      REG_STAT_DATAFRAME0_LENGTH0_LSB,
      REG_STAT_DATAFRAME0_LENGTH0_MSB,
      REG_STAT_DATAFRAME0_TYPE1,
      REG_STAT_DATAFRAME0_OFFSET1_LSB,
      REG_STAT_DATAFRAME0_OFFSET1_MSB,
      REG_STAT_DATAFRAME0_LENGTH1_LSB,
      REG_STAT_DATAFRAME0_LENGTH1_MSB,
      REG_STAT_DATAFRAME0_TYPE2,
      REG_STAT_DATAFRAME0_OFFSET2_LSB,
      REG_STAT_DATAFRAME0_OFFSET2_MSB,
      REG_STAT_DATAFRAME0_LENGTH2_LSB,
      REG_STAT_DATAFRAME0_LENGTH2_MSB,
      REG_STAT_DATAFRAME0_TYPE3,
      REG_STAT_DATAFRAME0_OFFSET3_LSB,
      REG_STAT_DATAFRAME0_OFFSET3_MSB,
      REG_STAT_DATAFRAME0_LENGTH3_LSB,
      REG_STAT_DATAFRAME0_LENGTH3_MSB,
      REG_STAT_DATAFRAME1_TYPE0,
      REG_STAT_DATAFRAME1_OFFSET0_LSB,
      REG_STAT_DATAFRAME1_OFFSET0_MSB,
      REG_STAT_DATAFRAME1_LENGTH0_LSB,
      REG_STAT_DATAFRAME1_LENGTH0_MSB,
      REG_STAT_DATAFRAME1_TYPE1,
      REG_STAT_DATAFRAME1_OFFSET1_LSB,
      REG_STAT_DATAFRAME1_OFFSET1_MSB,
      REG_STAT_DATAFRAME1_LENGTH1_LSB,
      REG_STAT_DATAFRAME1_LENGTH1_MSB,
      REG_STAT_DATAFRAME1_TYPE2,
      REG_STAT_DATAFRAME1_OFFSET2_LSB,
      REG_STAT_DATAFRAME1_OFFSET2_MSB,
      REG_STAT_DATAFRAME1_LENGTH2_LSB,
      REG_STAT_DATAFRAME1_LENGTH2_MSB,
      REG_STAT_DATAFRAME1_TYPE3,
      REG_STAT_DATAFRAME1_OFFSET3_LSB,
      REG_STAT_DATAFRAME1_OFFSET3_MSB,
      REG_STAT_DATAFRAME1_LENGTH3_LSB,
      REG_STAT_DATAFRAME1_LENGTH3_MSB,
      REG_STAT_DATAFRAME2_TYPE0,
      REG_STAT_DATAFRAME2_OFFSET0_LSB,
      REG_STAT_DATAFRAME2_OFFSET0_MSB,
      REG_STAT_DATAFRAME2_LENGTH0_LSB,
      REG_STAT_DATAFRAME2_LENGTH0_MSB,
      REG_STAT_DATAFRAME2_TYPE1,
      REG_STAT_DATAFRAME2_OFFSET1_LSB,
      REG_STAT_DATAFRAME2_OFFSET1_MSB,
      REG_STAT_DATAFRAME2_LENGTH1_LSB,
      REG_STAT_DATAFRAME2_LENGTH1_MSB,
      REG_STAT_DATAFRAME2_TYPE2,
      REG_STAT_DATAFRAME2_OFFSET2_LSB,
      REG_STAT_DATAFRAME2_OFFSET2_MSB,
      REG_STAT_DATAFRAME2_LENGTH2_LSB,
      REG_STAT_DATAFRAME2_LENGTH2_MSB,
      REG_STAT_DATAFRAME2_TYPE3,
      REG_STAT_DATAFRAME2_OFFSET3_LSB,
      REG_STAT_DATAFRAME2_OFFSET3_MSB,
      REG_STAT_DATAFRAME2_LENGTH3_LSB,
      REG_STAT_DATAFRAME2_LENGTH3_MSB,
      REG_STAT_DATAFRAME3_TYPE0,
      REG_STAT_DATAFRAME3_OFFSET0_LSB,
      REG_STAT_DATAFRAME3_OFFSET0_MSB,
      REG_STAT_DATAFRAME3_LENGTH0_LSB,
      REG_STAT_DATAFRAME3_LENGTH0_MSB,
      REG_STAT_DATAFRAME3_TYPE1,
      REG_STAT_DATAFRAME3_OFFSET1_LSB,
      REG_STAT_DATAFRAME3_OFFSET1_MSB,
      REG_STAT_DATAFRAME3_LENGTH1_LSB,
      REG_STAT_DATAFRAME3_LENGTH1_MSB,
      REG_STAT_DATAFRAME3_TYPE2,
      REG_STAT_DATAFRAME3_OFFSET2_LSB,
      REG_STAT_DATAFRAME3_OFFSET2_MSB,
      REG_STAT_DATAFRAME3_LENGTH2_LSB,
      REG_STAT_DATAFRAME3_LENGTH2_MSB,
      REG_STAT_DATAFRAME3_TYPE3,
      REG_STAT_DATAFRAME3_OFFSET3_LSB,
      REG_STAT_DATAFRAME3_OFFSET3_MSB,
      REG_STAT_DATAFRAME3_LENGTH3_LSB,
      REG_STAT_DATAFRAME3_LENGTH3_MSB,


      -- 1 Communication with on board chips (SPI, I2C)

      REG_STAT_SPI_FIFO,
      REG_STAT_SPI_CHECKSUM,

      REG_STAT_I2C_FIFO_CFG1,
      REG_STAT_I2C_FIFO_PLL,
      REG_STAT_I2C_FIFO_SCALER,

      -- 2 Misc

      REG_STAT_LP_HPD,

      REG_STAT_EDID_DATA,

      REG_STAT_GEN1,

      REG_STAT_BOARD_ID,
      REG_STAT_BUTTONS,

      REG_STAT_VIDEO_JTAG,

      -- 3 Video

      REG_STAT_H_TOTAL_H,
      REG_STAT_H_TOTAL_L,
      REG_STAT_H_ACTIVE_H,
      REG_STAT_H_ACTIVE_L,
      REG_STAT_H_BP_H,
      REG_STAT_H_BP_L,
      REG_STAT_H_SYNC_WIDTH_H,
      REG_STAT_H_SYNC_WIDTH_L,
      REG_STAT_V_TOTAL_H,
      REG_STAT_V_TOTAL_L,
      REG_STAT_V_ACTIVE_H,
      REG_STAT_V_ACTIVE_L,
      REG_STAT_V_BP,
      REG_STAT_V_SYNC_WIDTH,
      REG_STAT_H_FREQ_H,
      REG_STAT_H_FREQ_L,
      REG_STAT_V_FREQ_H,
      REG_STAT_V_FREQ_L,
      REG_STAT_P_FREQ_H,
      REG_STAT_P_FREQ_L,
      REG_STAT_VIDEO_MISC,

      REG_STAT_CRC_DVO_ERR_CNT_LL,
      REG_STAT_CRC_DVO_ERR_CNT_LH,
      REG_STAT_CRC_DVO_ERR_CNT_HL,
      REG_STAT_CRC_DVO_ERR_CNT_HH,

      REG_STAT_CRC_WRITE_ERR_CNT_LL,
      REG_STAT_CRC_WRITE_ERR_CNT_LH,
      REG_STAT_CRC_WRITE_ERR_CNT_HL,
      REG_STAT_CRC_WRITE_ERR_CNT_HH,

      REG_STAT_CRC_READ_ERR_CNT_LL,
      REG_STAT_CRC_READ_ERR_CNT_LH,
      REG_STAT_CRC_READ_ERR_CNT_HL,
      REG_STAT_CRC_READ_ERR_CNT_HH,

      REG_STAT_CRC_DVO_FRM_CNT_LL,
      REG_STAT_CRC_DVO_FRM_CNT_LH,
      REG_STAT_CRC_DVO_FRM_CNT_HL,
      REG_STAT_CRC_DVO_FRM_CNT_HH,

      REG_STAT_CRC_WRITE_FRM_CNT_LL,
      REG_STAT_CRC_WRITE_FRM_CNT_LH,
      REG_STAT_CRC_WRITE_FRM_CNT_HL,
      REG_STAT_CRC_WRITE_FRM_CNT_HH,

      REG_STAT_CRC_READ_FRM_CNT_LL,
      REG_STAT_CRC_READ_FRM_CNT_LH,
      REG_STAT_CRC_READ_FRM_CNT_HL,
      REG_STAT_CRC_READ_FRM_CNT_HH,

      REG_STAT_CRC_VAL_LL,
      REG_STAT_CRC_VAL_LH,
      REG_STAT_CRC_VAL_HL,
      REG_STAT_CRC_VAL_HH,

      REG_STAT_VIDEO_SINK_1,

      -- 4 HDCP

      REG_STAT_KSV_RAM_DATA,

      -- 5 Communication with Packet Router

      REG_STAT_TX_PACKET_GEN,

      REG_STAT_RX_PACKET_7_GTP0,
      REG_STAT_RX_PACKET_7_GTP1,
      REG_STAT_RX_PACKET_7_GTP2,
      REG_STAT_RX_PACKET_7_GTP3,
      REG_STAT_RX_PACKET_6_GTP0,
      REG_STAT_RX_PACKET_6_GTP1,
      REG_STAT_RX_PACKET_6_GTP2,
      REG_STAT_RX_PACKET_6_GTP3,
      REG_STAT_RX_PACKET_5_GTP0,
      REG_STAT_RX_PACKET_5_GTP1,
      REG_STAT_RX_PACKET_5_GTP2,
      REG_STAT_RX_PACKET_5_GTP3,
      REG_STAT_RX_PACKET_4_GTP0,
      REG_STAT_RX_PACKET_4_GTP1,
      REG_STAT_RX_PACKET_4_GTP2,
      REG_STAT_RX_PACKET_4_GTP3,
      REG_STAT_RX_PACKET_3_GTP0,
      REG_STAT_RX_PACKET_3_GTP1,
      REG_STAT_RX_PACKET_3_GTP2,
      REG_STAT_RX_PACKET_3_GTP3,
      REG_STAT_RX_PACKET_2_GTP0,
      REG_STAT_RX_PACKET_2_GTP1,
      REG_STAT_RX_PACKET_2_GTP2,
      REG_STAT_RX_PACKET_2_GTP3,
      REG_STAT_RX_PACKET_1_GTP0,
      REG_STAT_RX_PACKET_1_GTP1,
      REG_STAT_RX_PACKET_1_GTP2,
      REG_STAT_RX_PACKET_1_GTP3,
      REG_STAT_RX_PACKET_0_GTP0,
      REG_STAT_RX_PACKET_0_GTP1,
      REG_STAT_RX_PACKET_0_GTP2,
      REG_STAT_RX_PACKET_0_GTP3,
      REG_STAT_RX_PACKET_ADD_CAT_GTP0,
      REG_STAT_RX_PACKET_ADD_CAT_GTP1,
      REG_STAT_RX_PACKET_ADD_CAT_GTP2,
      REG_STAT_RX_PACKET_ADD_CAT_GTP3,
      REG_STAT_RX_PACKET_GEN_GTP0,
      REG_STAT_RX_PACKET_GEN_GTP1,
      REG_STAT_RX_PACKET_GEN_GTP2,
      REG_STAT_RX_PACKET_GEN_GTP3,

      -- 6 Packet Router

      REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_LL,
      REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_LH,
      REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_HL,
      REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_HH,

      REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_LL,
      REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_LH,
      REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_HL,
      REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_HH,

      REG_STAT_ROUTER_TESTER_A_CRC_LL,
      REG_STAT_ROUTER_TESTER_A_CRC_LH,
      REG_STAT_ROUTER_TESTER_A_CRC_HL,
      REG_STAT_ROUTER_TESTER_A_CRC_HH,

--      REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_LL,
--      REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_LH,
--      REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_HL,
--      REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_HH,
--
--      REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_LL,
--      REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_LH,
--      REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_HL,
--      REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_HH,
--
--      REG_STAT_ROUTER_TESTER_B_CRC_LL,
--      REG_STAT_ROUTER_TESTER_B_CRC_LH,
--      REG_STAT_ROUTER_TESTER_B_CRC_HL,
--      REG_STAT_ROUTER_TESTER_B_CRC_HH,

      REG_STAT_ROUTER_SFP0_STATUS,
      REG_STAT_ROUTER_SFP1_STATUS,
      REG_STAT_ROUTER_SFP2_STATUS,
      REG_STAT_ROUTER_SFP3_STATUS,

      -- Audio Stat register
      REG_STAT_AUDIO_HDMIRX_INFOFRAME0,
      REG_STAT_AUDIO_HDMIRX_INFOFRAME1,
      REG_STAT_AUDIO_EDID_SPEAKER_TO_INFOFRAME,
      --ICI REG_STAT_AUDIO_INFOFRAME_TO_CHANNEL_EN,

      REG_STAT_BOARD_QUAD,
      REG_STAT_VIDEO_ACTIVITY,
      REG_STAT_NO_BOARD_DETECTED,
      REG_STAT_USER_SWITCH_MODE,

      REG_STAT_SPI_DATA_MSB,
      REG_STAT_SPI_DATA_LSB,
      REG_STAT_SPI_ACK

   );

   -- Cpu interrupt registers (Set to 1 if rising edge in VHDL, clear to 0 if uC writes 0)
   type TCpuIntRegEnum is
   (
      -- 0 CPU

      REG_INT_EDGE_INT_CPU,

      REG_INT_MISC,

      REG_INT_EDGE_INT_CPU_OCCURED,
      REG_INT_LEVEL_INT_CPU_OCCURED,

      REG_INT_EDGE_DATA_FRAME0_OCCURED,
      REG_INT_EDGE_DATA_FRAME0,
      REG_INT_EDGE_DATA_FRAME1_OCCURED,
      REG_INT_EDGE_DATA_FRAME1,

      -- 1 Communication with on board chips (SPI, I2C)

      REG_INT_SPI,

      REG_INT_I2C_CFG1,
      REG_INT_I2C_PLL,
		REG_INT_I2C_SCALER
   );

   -- Cpu Ram mapping enum
  type TCpuRamRegEnum is
   (
   -- Ram to send data to a Rx module over the fiber.
      REG_TX_RAM_DATA_REGISTER,
      REG_RX0_RAM_DATA_REGISTER,
      REG_RX1_RAM_DATA_REGISTER,
      REG_RX2_RAM_DATA_REGISTER,
      REG_RX3_RAM_DATA_REGISTER
   );

   constant DATAWIDTH : integer := 8;
   constant ADDRWIDTH : integer := 16;
   
   type TRegAddInit is record
     vAdd         : std_logic_vector(ADDRWIDTH-1 downto 0);
     vInitVal     : std_logic_vector(DATAWIDTH-1 downto 0);
   end record;

   type TRegRamAddWidth is record
     vBaseAdd     : std_logic_vector(ADDRWIDTH-1 downto 0);
     vAddrWidth   : integer range 0 to 15;
   end record;

   type TCpuCtrlRegAccessArray   is array (TCpuCtrlRegEnum) of std_logic_vector(0 downto 0);
   type TCpuCtrlRegDataArray     is array (TCpuCtrlRegEnum) of std_logic_vector(DATAWIDTH-1 downto 0);
   type TCpuCtrlRegAddInitArray  is array (TCpuCtrlRegEnum) of TRegAddInit;

   type TCpuStatRegAccessArray   is array (TCpuStatRegEnum) of std_logic_vector(0 downto 0);
   type TCpuStatRegDataArray     is array (TCpuStatRegEnum) of std_logic_vector(DATAWIDTH-1 downto 0);
   type TCpuStatRegAddArray      is array (TCpuStatRegEnum) of std_logic_vector(ADDRWIDTH-1 downto 0);

   type TCpuIntRegAccessArray    is array (TCpuIntRegEnum)  of std_logic_vector(0 downto 0);
   type TCpuIntRegDataArray      is array (TCpuIntRegEnum)  of std_logic_vector(DATAWIDTH-1 downto 0);
   type TCpuIntRegAddArray       is array (TCpuIntRegEnum)  of std_logic_vector(ADDRWIDTH-1 downto 0);

   type TCpuRamWeArray           is array (TCpuRamRegEnum)  of std_logic_vector(0 downto 0);
   type TCpuRamDataArray         is array (TCpuRamRegEnum)  of std_logic_vector(DATAWIDTH-1 downto 0);
   type TCpuRamAddrArray         is array (TCpuRamRegEnum)  of std_logic_vector(ADDRWIDTH-1 downto 0);
   type TCpuRamAddrWidthArray    is array (TCpuRamRegEnum)  of TRegRamAddWidth;


   -- Cpu Ram mapping
   constant CTRL_RAM_ADD : TCpuRamAddrWidthArray :=
   (
   -- BaseAddr , AddrWidth
   -- Ram to send data to a Rx module over the fiber.
      (x"8000",   11),  -- REG_TX_RAM_DATA_REGISTER --the range cover by this def is from 0x8000 to 0x9FFF with 12 bit of address.
      (x"9000",   11),  -- REG_RX_RAM_DATA_REGISTER --the range cover by this def is from 0x8000 to 0x9FFF with 12 bit of address.
      (x"A000",   11),  -- REG_RX_RAM_DATA_REGISTER --the range cover by this def is from 0x8000 to 0x9FFF with 12 bit of address.
      (x"B000",   11),  -- REG_RX_RAM_DATA_REGISTER --the range cover by this def is from 0x8000 to 0x9FFF with 12 bit of address.
      (x"C000",   11)  -- REG_RX_RAM_DATA_REGISTER --the range cover by this def is from 0x8000 to 0x9FFF with 12 bit of address.
   );

   -- Cpu control registers address
   constant CTRL_REG_ADD_INIT : TCpuCtrlRegAddInitArray :=
   (
      -- ADD      INIT

      -- 0 CPU

      (x"0000",   x"00"),  -- REG_CTRL_FIRMWARE_VERSION_PROD
      (x"0001",   x"00"),  -- REG_CTRL_FIRMWARE_VERSION_MAJ
      (x"0002",   x"00"),  -- REG_CTRL_FIRMWARE_VERSION_MIN

      (x"0003",   x"00"),  -- REG_CTRL_MASK_LEVEL_INT
      (x"0004",   x"00"),  -- REG_CTRL_MASK_EDGE_INT

      (x"0005",   x"00"),  -- REG_CTRL_DEBUG
                              -- For debug purpose

      (x"000C",   x"00"),  -- REG_CTRL_USB
                              -- Bit 0:      USB Soft connect
                              -- Bit 1:      USB Suspend
                              -- Bit 2:      USB Mode
                              -- Bit 3:      USB Speed
                              -- Bit [7:4]:  Unused
      (x"000D",   x"00"),  -- REG_CTRL_USB_PROD_ID
                              -- USB Product ID
      (x"000E",   x"00"),  -- REG_CTRL_USB_STR_IDX
                              -- USB String index
      (x"000F",   x"00"),  -- REG_CTRL_USB_SERIAL_7
                              -- USB Serial number (7 downto 0 MSB to LSB)
      (x"0010",   x"00"),  -- REG_CTRL_USB_SERIAL_6
      (x"0011",   x"00"),  -- REG_CTRL_USB_SERIAL_5
      (x"0012",   x"00"),  -- REG_CTRL_USB_SERIAL_4
      (x"0013",   x"00"),  -- REG_CTRL_USB_SERIAL_3
      (x"0014",   x"00"),  -- REG_CTRL_USB_SERIAL_2
      (x"0015",   x"00"),  -- REG_CTRL_USB_SERIAL_1
      (x"0016",   x"00"),  -- REG_CTRL_USB_SERIAL_0
      (x"0017",   x"00"),  -- REG_CTRL_USB_BUF_ADD
                              -- USB Buffer Address
      (x"0018",   x"00"),  -- REG_CTRL_USB_BUF_DATA
                              -- USB Buffer Write Data
      (x"0019",   x"00"),  -- REG_CTRL_USB_BUF_WE
                              -- Bit 0:      USB Buffer Write Enable
                              -- Bit [7:1]:  Unused

      -- icap control register
      (x"001A",   x"00"),  -- REG_CTRL_ICAP_SEND,
      (x"001B",   x"00"),  -- REG_CTRL_ICAP_OPCODE_LSB,
      (x"001C",   x"00"),  -- REG_CTRL_ICAP_OPCODE_MSB,
      (x"001D",   x"00"),  -- REG_CTRL_ICAP_USERDATA_LSB,
      (x"001E",   x"00"),  -- REG_CTRL_ICAP_USERDATA_MSB,
      (x"001F",   x"00"),  -- REG_CTRL_ICAP_FALLBACK,

      (x"0030",   x"00"),  -- REG_CTRL_DATAFRAME_0_TXCTRL,
      (x"0031",   x"00"),  -- REG_CTRL_DATAFRAME_0_TYPE,
      (x"0032",   x"00"),  -- REG_CTRL_DATAFRAME_0_OFFSET_LSB,
      (x"0033",   x"00"),  -- REG_CTRL_DATAFRAME_0_OFFSET_MSB,
      (x"0034",   x"00"),  -- REG_CTRL_DATAFRAME_0_LENGTH_LSB,
      (x"0035",   x"00"),  -- REG_CTRL_DATAFRAME_0_LENGTH_MSB,
      
      (x"0040",   x"00"),  -- REG_CTRL_DATAFRAME_1_TXCTRL,
      (x"0041",   x"00"),  -- REG_CTRL_DATAFRAME_1_TYPE,
      (x"0042",   x"00"),  -- REG_CTRL_DATAFRAME_1_OFFSET_LSB,
      (x"0043",   x"00"),  -- REG_CTRL_DATAFRAME_1_OFFSET_MSB,
      (x"0044",   x"00"),  -- REG_CTRL_DATAFRAME_1_LENGTH_LSB,
      (x"0045",   x"00"),  -- REG_CTRL_DATAFRAME_1_LENGTH_MSB,
      
      (x"0050",   x"00"),  -- REG_CTRL_DATAFRAME_2_TXCTRL,
      (x"0051",   x"00"),  -- REG_CTRL_DATAFRAME_2_TYPE,
      (x"0052",   x"00"),  -- REG_CTRL_DATAFRAME_2_OFFSET_LSB,
      (x"0053",   x"00"),  -- REG_CTRL_DATAFRAME_2_OFFSET_MSB,
      (x"0054",   x"00"),  -- REG_CTRL_DATAFRAME_2_LENGTH_LSB,
      (x"0055",   x"00"),  -- REG_CTRL_DATAFRAME_2_LENGTH_MSB,
      
      (x"0060",   x"00"),  -- REG_CTRL_DATAFRAME_3_TXCTRL,
      (x"0061",   x"00"),  -- REG_CTRL_DATAFRAME_3_TYPE,
      (x"0062",   x"00"),  -- REG_CTRL_DATAFRAME_3_OFFSET_LSB,
      (x"0063",   x"00"),  -- REG_CTRL_DATAFRAME_3_OFFSET_MSB,
      (x"0064",   x"00"),  -- REG_CTRL_DATAFRAME_3_LENGTH_LSB,
      (x"0065",   x"00"),  -- REG_CTRL_DATAFRAME_3_LENGTH_MSB,

      (x"0066",   x"00"),  -- REG_CTRL_MASK_EDGE_FRAME0
      (x"0067",   x"00"),  -- REG_CTRL_MASK_EDGE_FRAME1

      (x"0068",   x"01"),  -- REG_CTRL_SERIAL_0
      (x"0069",   x"00"),  -- REG_CTRL_SERIAL_1
      (x"006A",   x"00"),  -- REG_CTRL_SERIAL_2
      (x"006B",   x"00"),  -- REG_CTRL_SEED_EN

      (x"0070",   x"00"),  -- REG_CTRL_FIRMWARE_VERSION_BUILD_LSB
      (x"0071",   x"00"),  -- REG_CTRL_FIRMWARE_VERSION_BUILD_MSB
      
      -- 1 Communication with on board chips

      (x"0100",   x"00"),  -- REG_CTRL_SPI
                              -- General SPI Control
                              -- Bit 0:      Go (indicates SPI master state machine to start)
                              -- Bit 1:      Write Enable SPI Write Fifo
                              -- Bit 2:      Read Enable SPI Read Fifo
                              -- Bit 3:      Clear SPI Write Fifo
                              -- Bit 4:      Clear SPI Read Fifo
                              -- Bit 5:      Read WriteN (0: Write, 1: Read)
                              -- Bit 6:      Command with data (1: Send/receive data, 1: Don't send/receive data)
                              -- Bit 7:      Command with address (0: Don't send address, 1: Send address)
      (x"0101",   x"00"),  -- REG_CTRL_SPI_REQUEST
                              -- SPI request
                              -- 0: Basic SPI command, local flash
                              -- 1: Basic SPI command, external flash (via header)
                              -- 2: Calculate checksum of portion of SPI device data, local
                              -- 3: Calculate checksum of portion of SPI device data, external flash (via header)
                              -- 4: Copy to local flash
                              -- 5: Copy to external flash (via header)
                              -- 6: Copy to fibers
      (x"0102",   x"00"),  -- REG_CTRL_SPI_CMD
                              -- SPI command
      (x"0103",   x"00"),  -- REG_CTRL_SPI_SRC_START_ADD_HL
                              -- Spi Source Start Address
      (x"0104",   x"00"),  -- REG_CTRL_SPI_SRC_START_ADD_LH
      (x"0105",   x"00"),  -- REG_CTRL_SPI_SRC_START_ADD_LL
      (x"0106",   x"00"),  -- REG_CTRL_SPI_SRC_END_ADD_HL
                              -- Spi Source End Address
      (x"0107",   x"00"),  -- REG_CTRL_SPI_SRC_END_ADD_LH
      (x"0108",   x"00"),  -- REG_CTRL_SPI_SRC_END_ADD_LL
      (x"0109",   x"00"),  -- REG_CTRL_SPI_DEST_START_ADD_HL
                              -- Spi Destination Start Address
      (x"010A",   x"00"),  -- REG_CTRL_SPI_DEST_START_ADD_LH
      (x"010B",   x"00"),  -- REG_CTRL_SPI_DEST_START_ADD_LL
      (x"010C",   x"00"),  -- REG_CTRL_SPI_LENGTH
                              -- Length
      (x"010D",   x"00"),  -- REG_CTRL_SPI_FIFO
                              -- Data to write in SPI Fifo

      (x"010E",   x"00"),  -- REG_CTRL_I2C_CFG1
                              -- General I2C Control
                              -- Bit 0:      Go (indicates I2C master state machine to start)
                              -- Bit 1:      Write Enable I2C Write Fifo
                              -- Bit 2:      Read Enable I2C Read Fifo
                              -- Bit 3:      Clear I2C Write Fifo
                              -- Bit 4:      Clear I2C Read Fifo
                              -- Bit [7:5]:  Unused
      (x"010F",   x"00"),  -- REG_CTRL_I2C_PLL
      (x"0110",   x"00"),  -- REG_CTRL_I2C_SCALER

      (x"0111",   x"00"),  -- REG_CTRL_I2C_DEV_CFG1
                              -- I2C Device Address
      (x"0112",   x"00"),  -- REG_CTRL_I2C_DEV_PLL
      (x"0113",   x"00"),  -- REG_CTRL_I2C_DEV_SCALER

      (x"0114",   x"00"),  -- REG_CTRL_I2C_REG_CFG1
                              -- Register Address
      (x"0115",   x"00"),  -- REG_CTRL_I2C_REG_PLL
      (x"0116",   x"00"),  -- REG_CTRL_I2C_REG_SCALER

      (x"0117",   x"00"),  -- REG_CTRL_I2C_LENGTH_CFG1
                              -- Length
      (x"0118",   x"00"),  -- REG_CTRL_I2C_LENGTH_PLL
      (x"0119",   x"00"),  -- REG_CTRL_I2C_LENGTH_SCALER

      (x"011A",   x"00"),  -- REG_CTRL_I2C_FIFO_CFG1
                              -- Data to write in I2C Fifo
      (x"011B",   x"00"),  -- REG_CTRL_I2C_FIFO_PLL
      (x"011C",   x"00"),  -- REG_CTRL_I2C_FIFO_SCALER

      -- 2 Misc

      (x"0200",   x"00"),  -- REG_CTRL_RST
                              -- Reset
                              -- Bit 0:      Reset Silicon Image Chips
                              -- Bit 1:      Reload FPGA
                              -- Bit 2:      Unused
                              -- Bit 3:      Unused
                              -- Bit 4:      Unused
                              -- Bit 5:      Unused
                              -- Bit 6:      Unused
                              -- Bit 7:      Unused

      (x"0201",   x"00"),  -- REG_CTRL_EDID_ADD
      (x"0202",   x"00"),  -- REG_CTRL_EDID_DATA
      (x"0203",   x"00"),  -- REG_CTRL_EDID_MISC
                              -- Bit 0:      Wren
                              -- Bit 1:      Unused
                              -- Bit 2:      Unused
                              -- Bit 3:      Unused
                              -- Bit 4:      Edid address bit 8
                              -- Bit 5:      Edid address bit 9
                              -- Bit 6:      Edid address bit 10
                              -- Bit 7:      Unused

      (x"0204",   x"00"),  -- REG_CTRL_GEN1
                              -- Bit 0:      Output programmed for video active in
                              -- Bit 1:      Video module detected is a RX
                              -- Bit 2:      Start 5 second HPD timer
                              -- Bit 3:      Start 5 second REG_CTRL_RST(2) timer (enable back all interrupts if timeout)
                              -- Bit 4:      Unused
                              -- Bit 5:      Unused
                              -- Bit 6:      Edid status bit 0:
                              -- Bit 7:      Edid status bit 1:

      (x"0205",   x"00"),  --REG_CTRL_BUTTONS
                              -- Bit 0 : Lock Pannels buttons
										-- Bit 1 : Reset Flag
										-- Bit 2 : Reset Led blink
                              -- others not used

      (x"0206",   x"00"),  -- REG_CTRL_VIDEO_JTAG
                              -- Bit 0 : Jtag Sel (0 = not active, 1 = active)
                              -- Bit 1 : Jtag Tck
                              -- Bit 2 : Jtag Tms
                              -- Bit 3 : Jtag Tdi
                              -- others not used


      -- 3 Video

      (x"0300",   x"00"),  -- REG_CTRL_H_TOTAL_H
      (x"0301",   x"00"),  -- REG_CTRL_H_TOTAL_L
      (x"0302",   x"00"),  -- REG_CTRL_H_ACTIVE_H
      (x"0303",   x"00"),  -- REG_CTRL_H_ACTIVE_L
      (x"0304",   x"00"),  -- REG_CTRL_H_BP_H
      (x"0305",   x"00"),  -- REG_CTRL_H_BP_L
      (x"0306",   x"00"),  -- REG_CTRL_H_SYNC_WIDTH_H
      (x"0307",   x"00"),  -- REG_CTRL_H_SYNC_WIDTH_L
      (x"0308",   x"00"),  -- REG_CTRL_V_TOTAL_H
      (x"0309",   x"00"),  -- REG_CTRL_V_TOTAL_L
      (x"030A",   x"00"),  -- REG_CTRL_V_ACTIVE_H
      (x"030B",   x"00"),  -- REG_CTRL_V_ACTIVE_L
      (x"030C",   x"00"),  -- REG_CTRL_V_BP
      (x"030D",   x"00"),  -- REG_CTRL_V_SYNC_WIDTH
      (x"030E",   x"00"),  -- REG_CTRL_H_FREQ_H
      (x"030F",   x"00"),  -- REG_CTRL_H_FREQ_L
      (x"0310",   x"00"),  -- REG_CTRL_V_FREQ_H
      (x"0311",   x"00"),  -- REG_CTRL_V_FREQ_L
      (x"0340",   x"00"),  -- REG_CTRL_P_FREQ_H
      (x"0341",   x"00"),  -- REG_CTRL_P_FREQ_L
      (x"0312",   x"00"),  -- REG_CTRL_VIDEO_MISC
                              -- Bit 0: V polarity
                              -- Bit 1: H polarity
                              -- Bit 2: Interlaced
                              -- Bit 3: Unused
                              -- Bit 4: Unused
                              -- Bit 5: Unused
                              -- Bit 6: Hdcp programmed
                              -- Bit 7: bStable (timings programmed in registers)
      (x"0313",   x"00"),  -- REG_CTRL_VIDEO_MODE

      (x"0328",   x"00"),  -- REG_CTRL_CRC

      (x"0329",   x"44"),  -- REG_CTRL_VIDEO_SINK_1
      (x"032A",   x"FF"),  -- REG_CTRL_VIDEO_SINK_2
      (x"032B",   x"FF"),  -- REG_CTRL_VIDEO_SINK_3
      (x"032C",   x"20"),  -- REG_CTRL_VIDEO_SINK_4
      (x"032D",   x"00"),  -- REG_CTRL_VIDEO_SINK_5
      (x"032E",   x"00"),  -- REG_CTRL_VIDEO_SINK_6

      -- 4 HDCP

      (x"0400",   x"00"),  -- REG_CTRL_HDCP_CPBL
                              -- Monitor connected on Loop-Back HDMI Tx supports HDCP
                              -- Bit 0:      PORT1
                              -- Bit 1:      Unused
                              -- Bit 2:      Unused
                              -- Bit 3:      Unused
                              -- Bit 4:      Unused
                              -- Bit 5:      Unused
                              -- Bit 6:      Unused
                              -- Bit 7:      Unused

      (x"0401",   x"00"),  -- REG_CTRL_HDCP_BCAPS_PORT1
                              -- BCaps of monitor connected to HDMI Tx

      (x"0402",   x"00"),  -- REG_CTRL_KSV_RAM_ADD (8 LSB)
      (x"0403",   x"00"),  -- REG_CTRL_KSV_RAM_MISC
                              -- Bit [1:0]:  KSV Ram Address bits 9:8  
                              -- Bit 2:      KSV Ram Busy
                              -- Bit 3:      Send key now (a new key as been writen)
                              -- Bit [6:4]:  Unused
                              -- Bit 7:      KSV Ram Write Enable
      (x"0404",   x"00"),  -- REG_CTRL_KSV_RAM_DATA

      (x"0405",   x"00"),  -- REG_CTRL_NEW_BKSV

      (x"0406",   x"00"),  -- REG_CTRL_HDCP_IN_ENABLED

      --(x"0407",   x"00"),  -- REG_CTRL_TOGGLE_HPD_IN

      (x"0408",   x"00"),  -- REG_CTRL_KSV_RAM_POINTER_LOCAL
      --(x"0409",   x"00"),  -- REG_CTRL_KSV_RAM_POINTER_DOWN

      -- 5 Communication with Packet Router

      (x"0500",   x"00"),  -- REG_CTRL_TX_PACKET_7
      (x"0501",   x"00"),  -- REG_CTRL_TX_PACKET_6
      (x"0502",   x"00"),  -- REG_CTRL_TX_PACKET_5
      (x"0503",   x"00"),  -- REG_CTRL_TX_PACKET_4
      (x"0504",   x"00"),  -- REG_CTRL_TX_PACKET_3
      (x"0505",   x"00"),  -- REG_CTRL_TX_PACKET_2
      (x"0506",   x"00"),  -- REG_CTRL_TX_PACKET_1
      (x"0507",   x"00"),  -- REG_CTRL_TX_PACKET_0
      (x"0508",   x"00"),  -- REG_CTRL_TX_PACKET_ADD_CAT
                              -- Bit [3:0]:  Packet category
                              -- Bit [7:4]:  Packet address
      (x"0509",   x"00"),  -- REG_CTRL_TX_PACKET_GEN
                              -- Bit [1:0]:  Packet priority
                              -- Bit [6:2]:  Unused
                              -- Bit 7:      TX packet fifo Wren

      (x"050A",   x"00"),  -- REG_CTRL_RX_PACKET_GEN_GTP0
                              -- Bit 0:      Unused
                              -- Bit 1:      Unused
                              -- Bit 2:      Unused
                              -- Bit 3:      Unused
                              -- Bit 4:      Unused
                              -- Bit 5:      Unused
                              -- Bit 6:      Unused
                              -- Bit 7:      RX packet fifo Read
      (x"050B",   x"00"),  -- REG_CTRL_RX_PACKET_GEN_GTP1
      (x"050C",   x"00"),  -- REG_CTRL_RX_PACKET_GEN_GTP2
      (x"050D",   x"00"),  -- REG_CTRL_RX_PACKET_GEN_GTP3
--      (x"050E",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP1_GTP0
--      (x"050F",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP1_GTP1
--      (x"0510",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP1_GTP2
--      (x"0511",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP1_GTP3
--      (x"0512",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP1_GTP0
--      (x"0513",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP1_GTP1
--      (x"0514",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP1_GTP2
--      (x"0515",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP1_GTP3
--      (x"0516",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP1_GTP0
--      (x"0517",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP1_GTP1
--      (x"0518",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP1_GTP2
--      (x"0519",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP1_GTP3
--      (x"051A",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP1_GTP0
--      (x"051B",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP1_GTP1
--      (x"051C",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP1_GTP2
--      (x"051D",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP1_GTP3
--      (x"051E",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP1_GTP0
--      (x"051F",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP1_GTP1
--      (x"0520",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP1_GTP2
--      (x"0521",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP1_GTP3
--      (x"0522",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP1_GTP0
--      (x"0523",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP1_GTP1
--      (x"0524",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP1_GTP2
--      (x"0525",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP1_GTP3
--      (x"0526",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP2_GTP0
--      (x"0527",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP2_GTP1
--      (x"0528",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP2_GTP2
--      (x"0529",   x"00"),  -- REG_CTRL_RX_PACKET_CTRL_TMP2_GTP3
--      (x"052A",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP2_GTP0
--      (x"052B",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP2_GTP1
--      (x"052C",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP2_GTP2
--      (x"052D",   x"00"),  -- REG_CTRL_RX_PACKET_DATA1_TMP2_GTP3
--      (x"052E",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP2_GTP0
--      (x"052F",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP2_GTP1
--      (x"0530",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP2_GTP2
--      (x"0531",   x"00"),  -- REG_CTRL_RX_PACKET_DATA2_TMP2_GTP3
--      (x"0532",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP2_GTP0
--      (x"0533",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP2_GTP1
--      (x"0534",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP2_GTP2
--      (x"0535",   x"00"),  -- REG_CTRL_RX_PACKET_DATA3_TMP2_GTP3
--      (x"0536",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP2_GTP0
--      (x"0537",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP2_GTP1
--      (x"0538",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP2_GTP2
--      (x"0539",   x"00"),  -- REG_CTRL_RX_PACKET_DATA4_TMP2_GTP3
--      (x"053A",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP2_GTP0
--      (x"053B",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP2_GTP1
--      (x"053C",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP2_GTP2
--      (x"053D",   x"00"),  -- REG_CTRL_RX_PACKET_DATA5_TMP2_GTP3

      -- 6 Packet Router

      (x"0600",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_1
      (x"0601",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_2
      (x"0602",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_3
      (x"0603",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_4_LL
      (x"0604",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_4_LH
      (x"0605",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_4_HL
      (x"0606",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_TX_4_HH
      (x"0607",   x"00"),  -- REG_CTRL_ROUTER_TESTER_A_RX_1

--      (x"0608",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_1
--      (x"0609",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_2
--      (x"060A",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_3
--      (x"060B",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_4_LL
--      (x"060C",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_4_LH
--      (x"060D",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_4_HL
--      (x"060E",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_TX_4_HH
--      (x"060F",   x"00"),  -- REG_CTRL_ROUTER_TESTER_B_RX_1

      (x"0610",   x"03"),  -- REG_CTRL_ROUTER_BRIDGE_0_GENERAL_1
      (x"0611",   x"EE"),  -- REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_LL
      (x"0612",   x"EE"),  -- REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_LH
      (x"0613",   x"EE"),  -- REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_HL
      (x"0614",   x"0E"),  -- REG_CTRL_ROUTER_BRIDGE_0_CHANNEL_HH

      (x"0615",   x"03"),  -- REG_CTRL_ROUTER_BRIDGE_1_GENERAL_1
      (x"0616",   x"DD"),  -- REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_LL
      (x"0617",   x"DD"),  -- REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_LH
      (x"0618",   x"DD"),  -- REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_HL
      (x"0619",   x"0D"),  -- REG_CTRL_ROUTER_BRIDGE_1_CHANNEL_HH

      (x"061A",   x"03"),  -- REG_CTRL_ROUTER_BRIDGE_2_GENERAL_1
      (x"061B",   x"BB"),  -- REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_LL
      (x"061C",   x"BB"),  -- REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_LH
      (x"061D",   x"BB"),  -- REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_HL
      (x"061E",   x"0B"),  -- REG_CTRL_ROUTER_BRIDGE_2_CHANNEL_HH

      (x"061F",   x"03"),  -- REG_CTRL_ROUTER_BRIDGE_3_GENERAL_1
      (x"0620",   x"77"),  -- REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_LL
      (x"0621",   x"77"),  -- REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_LH
      (x"0622",   x"77"),  -- REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_HL
      (x"0623",   x"07"),  -- REG_CTRL_ROUTER_BRIDGE_3_CHANNEL_HH

      (x"0624",   x"B8"),  -- REG_CTRL_ROUTER_SFP_TX_STATUS_LED_0
      (x"0625",   x"B8"),  -- REG_CTRL_ROUTER_SFP_TX_STATUS_LED_1
      (x"0626",   x"B8"),  -- REG_CTRL_ROUTER_SFP_TX_STATUS_LED_2
      (x"0627",   x"B8"),  -- REG_CTRL_ROUTER_SFP_TX_STATUS_LED_3

      (x"0628",   x"B8"),  -- REG_CTRL_ROUTER_SFP_RX_STATUS_LED_0
      (x"0629",   x"B8"),  -- REG_CTRL_ROUTER_SFP_RX_STATUS_LED_1
      (x"062A",   x"B8"),  -- REG_CTRL_ROUTER_SFP_RX_STATUS_LED_2
      (x"062B",   x"B8"),  -- REG_CTRL_ROUTER_SFP_RX_STATUS_LED_3

      -- 7 Audio register

      (x"0701",   x"00"),  -- REG_CTRL_AUDIO_TONE_MODE
      (x"0702",   x"00"),  -- REG_CTRL_AUDIO_AUX_DAC_DATA
      (x"0703",   x"00"),  -- REG_CTRL_AUDIO_AUX_DAC_ADDR
      (x"0704",   x"00"),  -- REG_CTRL_AUDIO_AUX_DAC_WE
      (x"0705",   x"98"),  -- REG_CTRL_AUDIO_AUX_CH_SEL
      (x"0706",   x"10"),  -- REG_CTRL_AUDIO_HDMI_CH_SEL0
      (x"0707",   x"32"),  -- REG_CTRL_AUDIO_HDMI_CH_SEL1
      (x"0708",   x"54"),  -- REG_CTRL_AUDIO_HDMI_CH_SEL2
      (x"0709",   x"76"),  -- REG_CTRL_AUDIO_HDMI_CH_SEL3
      (x"070a",   x"00"),  -- REG_CTRL_AUDIO_INSEL_MODE
      (x"070e",   x"00"),  -- REG_CTRL_AUDIO_EDID_SPEAKER_TO_IF_LUT
      (x"070f",   x"00"),  -- REG_CTRL_AUDIO_DM_PROC_RAM_ADDR,
      (x"0710",   x"00"),  -- REG_CTRL_AUDIO_DM_PROC_RAM_DATA,
      (x"0711",   x"00"),  -- REG_CTRL_AUDIO_DM_PROC_RAM_WE
      (x"0715",   x"00"),  -- REG_CTRL_AUDIO_SAMPLING_FREQ

      (x"0900",   x"01"),                          --REG_CTRL_SWITCH_MODE

      (x"0901",   x"FF"),                          --REG_CTRL_CPU_SWITCH_PORT_MODE
      (x"0902",   x"00"),                          --REG_CTRL_CPU_SWITCH_PRIORITY_PORT0
      (x"0903",   x"00"),                          --REG_CTRL_CPU_SWITCH_PRIORITY_PORT1
      (x"0904",   x"00"),                          --REG_CTRL_CPU_SWITCH_PRIORITY_PORT2
      (x"0905",   x"00"),                          --REG_CTRL_CPU_SWITCH_PRIORITY_PORT3

      (x"0906",   x"55"),                          --REG_CTRL_VIDEO_SWITCH_PORT_MODE,
      (x"0907",   x"B4"),                          --REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT0,
      (x"0908",   x"B4"),                          --REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT1,
      (x"0909",   x"B4"),                          --REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT2,
      (x"090A",   x"B4"),                          --REG_CTRL_VIDEO_SWITCH_PRIORITY_PORT3,

      (x"090B",   x"FF"),                          --REG_CTRL_AUDIO_SWITCH_PORT_MODE,
      (x"090C",   x"00"),                          --REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT0,
      (x"090D",   x"00"),                          --REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT1,
      (x"090E",   x"00"),                          --REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT2,
      (x"090F",   x"00"),                          --REG_CTRL_AUDIO_SWITCH_PRIORITY_PORT3,

      (x"0910",   x"FF"),                          --REG_CTRL_RTESTER_SWITCH_PORT_MODE,
      (x"0911",   x"00"),                          --REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT0,
      (x"0912",   x"00"),                          --REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT1,
      (x"0913",   x"00"),                          --REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT2,
      (x"0914",   x"00"),                          --REG_CTRL_RTESTER_SWITCH_PRIORITY_PORT3,

      (x"0915",   x"FF"),                          --REG_CTRL_SAI_SWITCH_PORT_MODE,
      (x"0916",   x"00"),                          --REG_CTRL_SAI_SWITCH_PRIORITY_PORT0,
      (x"0917",   x"00"),                          --REG_CTRL_SAI_SWITCH_PRIORITY_PORT1,
      (x"0918",   x"00"),                          --REG_CTRL_SAI_SWITCH_PRIORITY_PORT2,
      (x"0919",   x"00"),                          --REG_CTRL_SAI_SWITCH_PRIORITY_PORT3,

      (x"0A08",   x"00"),                           --REG_CTRL_SPI_ADR_MSB,
      (x"0A09",   x"00"),                           --REG_CTRL_SPI_ADR_LSB,
      (x"0A0A",   x"00"),                           --REG_CTRL_SPI_DATA_MSB,
      (x"0A0B",   x"00"),                           --REG_CTRL_SPI_DATA_LSB,
      (x"0A0C",   x"00")                            --REG_CTRL_SPI_SEND,

   );

   -- Cpu status registers address
   constant STAT_REG_ADD : TCpuStatRegAddArray :=
   (
      -- 0 CPU

      x"4000",    -- REG_STAT_LEVEL_INT_CPU
                     -- CPU Interrupt status register (level interrupts)

      x"4001",    -- REG_STAT_USB
                     -- USB Status
                     -- Bit 0:      Usb Busy
                     -- Bit 1:      Crc 16 Error
                     -- Bit 2:      Crc 5 Error
                     -- Bit 3:      Rx Ack Timeout
                     -- Bit 4:      Usb Reset
                     -- Bit 5:      Output Full
                     -- Bit 6:      Ready To Send
                     -- Bit 7:      Unused
      x"4002",    -- REG_STAT_USB_BUF_DATA
                     -- USB Buffer Data Read

      x"4006",    -- REG_STAT_ICAP_BUSY,
      x"4007",    -- REG_STAT_ICAP_USERDATA_LSB,
      x"4008",    -- REG_STAT_ICAP_USERDATA_MSB,

      x"4010",    -- REG_STAT_DATAFRAME_0_TXCTRL
      x"4011",    -- REG_STAT_DATAFRAME_1_TXCTRL
      x"4012",    -- REG_STAT_DATAFRAME_2_TXCTRL
      x"4013",    -- REG_STAT_DATAFRAME_3_TXCTRL

      x"4020",    -- REG_STAT_DATAFRAME0_TYPE0,
      x"4021",    -- REG_STAT_DATAFRAME0_OFFSET0_LSB,
      x"4022",    -- REG_STAT_DATAFRAME0_OFFSET0_MSB,
      x"4023",    -- REG_STAT_DATAFRAME0_LENGTH0_LSB,
      x"4024",    -- REG_STAT_DATAFRAME0_LENGTH0_MSB,
      x"4028",    -- REG_STAT_DATAFRAME0_TYPE1,
      x"4029",    -- REG_STAT_DATAFRAME0_OFFSET1_LSB,
      x"402A",    -- REG_STAT_DATAFRAME0_OFFSET1_MSB,
      x"402B",    -- REG_STAT_DATAFRAME0_LENGTH1_LSB,
      x"402C",    -- REG_STAT_DATAFRAME0_LENGTH1_MSB,
      x"4030",    -- REG_STAT_DATAFRAME0_TYPE2,
      x"4031",    -- REG_STAT_DATAFRAME0_OFFSET2_LSB,
      x"4032",    -- REG_STAT_DATAFRAME0_OFFSET2_MSB,
      x"4033",    -- REG_STAT_DATAFRAME0_LENGTH2_LSB,
      x"4034",    -- REG_STAT_DATAFRAME0_LENGTH2_MSB,
      x"4038",    -- REG_STAT_DATAFRAME0_TYPE3,
      x"4039",    -- REG_STAT_DATAFRAME0_OFFSET3_LSB,
      x"403A",    -- REG_STAT_DATAFRAME0_OFFSET3_MSB,
      x"403B",    -- REG_STAT_DATAFRAME0_LENGTH3_LSB,
      x"403C",    -- REG_STAT_DATAFRAME0_LENGTH3_MSB,
      x"4040",    -- REG_STAT_DATAFRAME1_TYPE0,
      x"4041",    -- REG_STAT_DATAFRAME1_OFFSET0_LSB,
      x"4042",    -- REG_STAT_DATAFRAME1_OFFSET0_MSB,
      x"4043",    -- REG_STAT_DATAFRAME1_LENGTH0_LSB,
      x"4044",    -- REG_STAT_DATAFRAME1_LENGTH0_MSB,
      x"4048",    -- REG_STAT_DATAFRAME1_TYPE1,
      x"4049",    -- REG_STAT_DATAFRAME1_OFFSET1_LSB,
      x"404A",    -- REG_STAT_DATAFRAME1_OFFSET1_MSB,
      x"404B",    -- REG_STAT_DATAFRAME1_LENGTH1_LSB,
      x"404C",    -- REG_STAT_DATAFRAME1_LENGTH1_MSB,
      x"4050",    -- REG_STAT_DATAFRAME1_TYPE2,
      x"4051",    -- REG_STAT_DATAFRAME1_OFFSET2_LSB,
      x"4052",    -- REG_STAT_DATAFRAME1_OFFSET2_MSB,
      x"4053",    -- REG_STAT_DATAFRAME1_LENGTH2_LSB,
      x"4054",    -- REG_STAT_DATAFRAME1_LENGTH2_MSB,
      x"4058",    -- REG_STAT_DATAFRAME1_TYPE3,
      x"4059",    -- REG_STAT_DATAFRAME1_OFFSET3_LSB,
      x"405A",    -- REG_STAT_DATAFRAME1_OFFSET3_MSB,
      x"405B",    -- REG_STAT_DATAFRAME1_LENGTH3_LSB,
      x"405C",    -- REG_STAT_DATAFRAME1_LENGTH3_MSB,
      x"4060",    -- REG_STAT_DATAFRAME2_TYPE0,
      x"4061",    -- REG_STAT_DATAFRAME2_OFFSET0_LSB,
      x"4062",    -- REG_STAT_DATAFRAME2_OFFSET0_MSB,
      x"4063",    -- REG_STAT_DATAFRAME2_LENGTH0_LSB,
      x"4064",    -- REG_STAT_DATAFRAME2_LENGTH0_MSB,
      x"4068",    -- REG_STAT_DATAFRAME2_TYPE1,
      x"4069",    -- REG_STAT_DATAFRAME2_OFFSET1_LSB,
      x"406A",    -- REG_STAT_DATAFRAME2_OFFSET1_MSB,
      x"406B",    -- REG_STAT_DATAFRAME2_LENGTH1_LSB,
      x"406C",    -- REG_STAT_DATAFRAME2_LENGTH1_MSB,
      x"4070",    -- REG_STAT_DATAFRAME2_TYPE2,
      x"4071",    -- REG_STAT_DATAFRAME2_OFFSET2_LSB,
      x"4072",    -- REG_STAT_DATAFRAME2_OFFSET2_MSB,
      x"4073",    -- REG_STAT_DATAFRAME2_LENGTH2_LSB,
      x"4074",    -- REG_STAT_DATAFRAME2_LENGTH2_MSB,
      x"4078",    -- REG_STAT_DATAFRAME2_TYPE3,
      x"4079",    -- REG_STAT_DATAFRAME2_OFFSET3_LSB,
      x"407A",    -- REG_STAT_DATAFRAME2_OFFSET3_MSB,
      x"407B",    -- REG_STAT_DATAFRAME2_LENGTH3_LSB,
      x"407C",    -- REG_STAT_DATAFRAME2_LENGTH3_MSB,
      x"4080",    -- REG_STAT_DATAFRAME3_TYPE0,
      x"4081",    -- REG_STAT_DATAFRAME3_OFFSET0_LSB,
      x"4082",    -- REG_STAT_DATAFRAME3_OFFSET0_MSB,
      x"4083",    -- REG_STAT_DATAFRAME3_LENGTH0_LSB,
      x"4084",    -- REG_STAT_DATAFRAME3_LENGTH0_MSB,
      x"4088",    -- REG_STAT_DATAFRAME3_TYPE1,
      x"4089",    -- REG_STAT_DATAFRAME3_OFFSET1_LSB,
      x"408A",    -- REG_STAT_DATAFRAME3_OFFSET1_MSB,
      x"408B",    -- REG_STAT_DATAFRAME3_LENGTH1_LSB,
      x"408C",    -- REG_STAT_DATAFRAME3_LENGTH1_MSB,
      x"4090",    -- REG_STAT_DATAFRAME3_TYPE2,
      x"4091",    -- REG_STAT_DATAFRAME3_OFFSET2_LSB,
      x"4092",    -- REG_STAT_DATAFRAME3_OFFSET2_MSB,
      x"4093",    -- REG_STAT_DATAFRAME3_LENGTH2_LSB,
      x"4094",    -- REG_STAT_DATAFRAME3_LENGTH2_MSB,
      x"4098",    -- REG_STAT_DATAFRAME3_TYPE3,
      x"4099",    -- REG_STAT_DATAFRAME3_OFFSET3_LSB,
      x"409A",    -- REG_STAT_DATAFRAME3_OFFSET3_MSB,
      x"409B",    -- REG_STAT_DATAFRAME3_LENGTH3_LSB,
      x"409C",    -- REG_STAT_DATAFRAME3_LENGTH3_MSB,
      -- 1 Communication with on board chips

      x"4100",    -- REG_STAT_SPI_FIFO
                     -- Data read from I2C Fifo
      x"4101",    -- REG_STAT_SPI_CHECKSUM

      x"4102",    -- REG_STAT_I2C_FIFO_CFG1
                     -- Data read from I2C Fifo
      x"4103",    -- REG_STAT_I2C_FIFO_PLL
      x"4104",    -- REG_STAT_I2C_FIFO_SCALER

      -- 2 Misc

      x"4200",    -- REG_STAT_LP_HPD
                     -- Hot Plug Detect on Loop-Back HDMI Tx
                     -- Bit 0:      CFG1
                     -- Bit 1:      CFG2 Unused
                     -- Bit 2:      CFG3 Unused
                     -- Bit 3:      CFG4 Unused
                     -- Bit 4:      CFG5 Unused
                     -- Bit 5:      CFG6 Unused
                     -- Bit 6:      CFG7 Unused
                     -- Bit 7:      CFG8 Unused

      x"4201",    -- REG_STAT_EDID_DATA

      x"4202",    -- REG_STAT_GEN1
                     -- General purpose status
                     -- Bit 0:      Timer 0 has expired
                     -- Bit 1:      Timer 1 has expired
                     -- Bit 2:      5 second REG_CTRL_RST(2) timer 2 has expired (enable back all interrupts)
                     -- Bit 3:      Unused
                     -- Bit 4:      Unused
                     -- Bit 5:      sbShowEdidStatus
                     -- Bit 6:      Unused
                     -- Bit 7:      Unused

      x"4203",    -- REG_STAT_BOARD_ID
                     -- Bits [3:0]: Video board id
                     -- Bits [7:4]: Aux board id

      x"4204",    -- REG_STAT_BUTTONS
                      -- 0 : button 1
                      -- 1 : button 2
                      -- 2 : obPowerAndEdidStatus0RedN
                      -- 3 : obPowerAndEdidStatus0GrnN
                      -- 4 : obVideoBoardAndEdidStatus1RedN
                      -- 5 : obVideoBoardAndEdidStatus1GrnN
                      -- 6 : obAuxBoardAndEdidStatus2RedN
                      -- 7 : obAuxBoardAndEdidStatus2GrnN

      x"4205",    -- REG_STAT_VIDEO_JTAG
                     -- Bit 0 : Jtag Tdo
                     -- others not used

      -- 3 Video

      x"4300",     -- REG_STAT_H_TOTAL_H
      x"4301",     -- REG_STAT_H_TOTAL_L
      x"4302",     -- REG_STAT_H_ACTIVE_H
      x"4303",     -- REG_STAT_H_ACTIVE_L
      x"4304",     -- REG_STAT_H_BP_H
      x"4305",     -- REG_STAT_H_BP_L
      x"4306",     -- REG_STAT_H_SYNC_WIDTH_H
      x"4307",     -- REG_STAT_H_SYNC_WIDTH_L
      x"4308",     -- REG_STAT_V_TOTAL_H
      x"4309",     -- REG_STAT_V_TOTAL_L
      x"430A",     -- REG_STAT_V_ACTIVE_H
      x"430B",     -- REG_STAT_V_ACTIVE_L
      x"430C",     -- REG_STAT_V_BP
      x"430D",     -- REG_STAT_V_SYNC_WIDTH
      x"430E",     -- REG_STAT_H_FREQ_H
      x"430F",     -- REG_STAT_H_FREQ_L
      x"4310",     -- REG_STAT_V_FREQ_H
      x"4311",     -- REG_STAT_V_FREQ_L
      x"4340",     -- REG_STAT_P_FREQ_H
      x"4341",     -- REG_STAT_P_FREQ_L
      x"4312",     -- REG_STAT_VIDEO_MISC
                     -- Bit 0: V polarity
                     -- Bit 1: H polarity
                     -- Bit 2: Interlaced
                     -- Bit 3: Unused
                     -- Bit 4: Unused
                     -- Bit 5: Unused
                     -- Bit 6: Hdcp required
                     -- Bit 7: bStable (active video in and timings received on fiber are stable)

      x"4313",     -- REG_STAT_CRC_DVO_ERR_CNT_LL
      x"4314",     -- REG_STAT_CRC_DVO_ERR_CNT_LH
      x"4315",     -- REG_STAT_CRC_DVO_ERR_CNT_HL
      x"4316",     -- REG_STAT_CRC_DVO_ERR_CNT_HH

      x"4317",     -- REG_STAT_CRC_WRITE_ERR_CNT_LL
      x"4318",     -- REG_STAT_CRC_WRITE_ERR_CNT_LH
      x"4319",     -- REG_STAT_CRC_WRITE_ERR_CNT_HL
      x"431A",     -- REG_STAT_CRC_WRITE_ERR_CNT_HH

      x"431B",     -- REG_STAT_CRC_READ_ERR_CNT_LL
      x"431C",     -- REG_STAT_CRC_READ_ERR_CNT_LH
      x"431D",     -- REG_STAT_CRC_READ_ERR_CNT_HL
      x"431E",     -- REG_STAT_CRC_READ_ERR_CNT_HH

      x"431F",     -- REG_STAT_CRC_DVO_FRM_CNT_LL
      x"4320",     -- REG_STAT_CRC_DVO_FRM_CNT_LH
      x"4321",     -- REG_STAT_CRC_DVO_FRM_CNT_HL
      x"4322",     -- REG_STAT_CRC_DVO_FRM_CNT_HH

      x"4323",     -- REG_STAT_CRC_WRITE_FRM_CNT_LL
      x"4324",     -- REG_STAT_CRC_WRITE_FRM_CNT_LH
      x"4325",     -- REG_STAT_CRC_WRITE_FRM_CNT_HL
      x"4326",     -- REG_STAT_CRC_WRITE_FRM_CNT_HH

      x"4327",     -- REG_STAT_CRC_READ_FRM_CNT_LL
      x"4328",     -- REG_STAT_CRC_READ_FRM_CNT_LH
      x"4329",     -- REG_STAT_CRC_READ_FRM_CNT_HL
      x"432A",     -- REG_STAT_CRC_READ_FRM_CNT_HH

      x"432B",     -- REG_STAT_CRC_VAL_LL
      x"432C",     -- REG_STAT_CRC_VAL_LH
      x"432D",     -- REG_STAT_CRC_VAL_HL
      x"432E",     -- REG_STAT_CRC_VAL_HH

      x"4330",     -- REG_STAT_VIDEO_SINK_1

      -- 4 HDCP

      x"4400",    -- REG_STAT_KSV_RAM_DATA

      -- 5 Communication with Packet Router

      x"4500",    -- REG_STAT_TX_PACKET_GEN
                     -- Bit 0:      Unused
                     -- Bit 1:      Unused
                     -- Bit 2:      Unused
                     -- Bit 3:      Unused
                     -- Bit 4:      Unused
                     -- Bit 5:      Unused
                     -- Bit 6:      Unused
                     -- Bit 7:      TX packet fifo ready

      x"4501",    -- REG_STAT_RX_PACKET_7_GTP0
      x"4502",    -- REG_STAT_RX_PACKET_7_GTP1
      x"4503",    -- REG_STAT_RX_PACKET_7_GTP2
      x"4504",    -- REG_STAT_RX_PACKET_7_GTP3
      x"4505",    -- REG_STAT_RX_PACKET_6_GTP0
      x"4506",    -- REG_STAT_RX_PACKET_6_GTP1
      x"4507",    -- REG_STAT_RX_PACKET_6_GTP2
      x"4508",    -- REG_STAT_RX_PACKET_6_GTP3
      x"4509",    -- REG_STAT_RX_PACKET_5_GTP0
      x"450A",    -- REG_STAT_RX_PACKET_5_GTP1
      x"450B",    -- REG_STAT_RX_PACKET_5_GTP2
      x"450C",    -- REG_STAT_RX_PACKET_5_GTP3
      x"450D",    -- REG_STAT_RX_PACKET_4_GTP0
      x"450E",    -- REG_STAT_RX_PACKET_4_GTP1
      x"450F",    -- REG_STAT_RX_PACKET_4_GTP2
      x"4510",    -- REG_STAT_RX_PACKET_4_GTP3
      x"4511",    -- REG_STAT_RX_PACKET_3_GTP0
      x"4512",    -- REG_STAT_RX_PACKET_3_GTP1
      x"4513",    -- REG_STAT_RX_PACKET_3_GTP2
      x"4514",    -- REG_STAT_RX_PACKET_3_GTP3
      x"4515",    -- REG_STAT_RX_PACKET_2_GTP0
      x"4516",    -- REG_STAT_RX_PACKET_2_GTP1
      x"4517",    -- REG_STAT_RX_PACKET_2_GTP2
      x"4518",    -- REG_STAT_RX_PACKET_2_GTP3
      x"4519",    -- REG_STAT_RX_PACKET_1_GTP0
      x"451A",    -- REG_STAT_RX_PACKET_1_GTP1
      x"451B",    -- REG_STAT_RX_PACKET_1_GTP2
      x"451C",    -- REG_STAT_RX_PACKET_1_GTP3
      x"451D",    -- REG_STAT_RX_PACKET_0_GTP0
      x"451E",    -- REG_STAT_RX_PACKET_0_GTP1
      x"451F",    -- REG_STAT_RX_PACKET_0_GTP2
      x"4520",    -- REG_STAT_RX_PACKET_0_GTP3
      x"4521",    -- REG_STAT_RX_PACKET_ADD_CAT_GTP0
                     -- Bit [3:0]:  Packet category
                     -- Bit [7:4]:  Packet address
      x"4522",    -- REG_STAT_RX_PACKET_ADD_CAT_GTP1
      x"4523",    -- REG_STAT_RX_PACKET_ADD_CAT_GTP2
      x"4524",    -- REG_STAT_RX_PACKET_ADD_CAT_GTP3
      x"4525",    -- REG_STAT_RX_PACKET_GEN_GTP0
                     -- Bit [6:0]:  Unused
                     -- Bit 7:      RX packet fifo empty
      x"4526",    -- REG_STAT_RX_PACKET_GEN_GTP1
      x"4527",    -- REG_STAT_RX_PACKET_GEN_GTP2
      x"4528",    -- REG_STAT_RX_PACKET_GEN_GTP3

      -- 6 Packet Router

      x"4600",     -- REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_LL
      x"4601",     -- REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_LH
      x"4602",     -- REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_HL
      x"4603",     -- REG_STAT_ROUTER_TESTER_A_FRAME_COUNT_HH

      x"4604",     -- REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_LL
      x"4605",     -- REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_LH
      x"4606",     -- REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_HL
      x"4607",     -- REG_STAT_ROUTER_TESTER_A_ERROR_COUNT_HH

      x"4608",     -- REG_STAT_ROUTER_TESTER_A_CRC_LL
      x"4609",     -- REG_STAT_ROUTER_TESTER_A_CRC_LH
      x"460A",     -- REG_STAT_ROUTER_TESTER_A_CRC_HL
      x"460B",     -- REG_STAT_ROUTER_TESTER_A_CRC_HH

--      x"460C",     -- REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_LL
--      x"460D",     -- REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_LH
--      x"460E",     -- REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_HL
--      x"460F",     -- REG_STAT_ROUTER_TESTER_B_FRAME_COUNT_HH
--
--      x"4610",     -- REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_LL
--      x"4611",     -- REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_LH
--      x"4612",     -- REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_HL
--      x"4613",     -- REG_STAT_ROUTER_TESTER_B_ERROR_COUNT_HH
--
--      x"4614",     -- REG_STAT_ROUTER_TESTER_B_CRC_LL
--      x"4615",     -- REG_STAT_ROUTER_TESTER_B_CRC_LH
--      x"4616",     -- REG_STAT_ROUTER_TESTER_B_CRC_HL
--      x"4617",     -- REG_STAT_ROUTER_TESTER_B_CRC_HH

      x"4620",     -- REG_STAT_ROUTER_SFP0_STATUS
      x"4621",     -- REG_STAT_ROUTER_SFP1_STATUS
      x"4622",     -- REG_STAT_ROUTER_SFP2_STATUS
      x"4623",     -- REG_STAT_ROUTER_SFP3_STATUS

      -- Audio Stat register
      x"4700",     -- REG_STAT_AUDIO_HDMIRX_INFOFRAME0
      x"4701",     -- REG_STAT_AUDIO_HDMIRX_INFOFRAME1
      x"4702",     -- REG_STAT_AUDIO_EDID_SPEAKER_TO_INFOFRAME
      --x"4703",     -- REG_STAT_AUDIO_INFOFRAME_TO_CHANNEL_EN

      x"4900",      --REG_STAT_BOARD_QUAD
      x"4901",      --REG_STAT_VIDEO_ACTIVITY 
      x"4902",      --REG_STAT_NO_BOARD_DETECTED
      x"4903",      --REG_STAT_USER_SWITCH_MODE
      x"4904",      --REG_STAT_SPI_DATA_MSB
      x"4905",      --REG_STAT_SPI_DATA_LSB
      x"4906"      --REG_STAT_SPI_ACK
   );

   -- Cpu interrupt registers address
   constant INT_REG_ADD : TCpuIntRegAddArray :=
   (
      -- 0 CPU

      x"5000",    -- REG_INT_EDGE_INT_CPU
                     -- CPU Interrupt status register (edge interrupts)

      x"5001",    -- REG_INT_MISC
                     -- USB status register that ca be cleared by uC
                     -- Bit 0:      USB Buf Empty
                     -- Bit 1:      Replace stored edid in titan eeprom (cleared by uC when received message from titan that edid was replaced)
                     -- Bit 2:      Replace stored edid in titan eeprom (cleared by uC when edid sent upstream)
                     -- Bit [7:3]:  Unused

      x"5002",    -- REG_INT_EDGE_INT_CPU_OCCURED
                     -- Edge interrupt occured, will not be cleared by uC
      x"5003",    -- REG_INT_LEVEL_INT_CPU_OCCURED
                     -- Level interrupt occured, will not be cleared by uC
      x"5004",    -- REG_INT_EDGE_DATA_FRAME0_OCCURED
      x"5005",    -- REG_INT_EDGE_DATA_FRAME0
      x"5006",    -- REG_INT_EDGE_DATA_FRAME1_OCCURED
      x"5007",    -- REG_INT_EDGE_DATA_FRAME1

      -- 1 Communication with on board chips

      x"5100",    -- REG_INT_SPI
                     -- SPI status register that can be cleared by uC
                     -- Bit 0:      I2C transaction done
                     -- Bit [7:1]:  Unused

      x"5101",    -- REG_INT_I2C_CFG1
                     -- I2C status register that can be cleared by uC
                     -- Bit 0:      I2C transaction done
                     -- Bit 1:      I2C transaction error
                     -- Bit [7:2]:  Unused
      x"5102",     -- REG_INT_I2C_PLL
      x"5103"     -- REG_INT_I2C_SCALER
   );

end package;
